const express = require("express");
const fs = require("fs");
const path = require("path");
const router = express.Router();

// Middleware para validar autenticación (opcional)
const authenticate = (req, res, next) => {
    const SECRET_KEY = process.env.SECRET_KEY || "0Uv09uIyf04MF2:iN>CQuh*Bi458";
    const authHeader = req.headers["authorization"];

    if (!authHeader || authHeader !== `Bearer ${SECRET_KEY}`) {
        return res.status(403).json({
            message: "Acceso no autorizado"
        });
    }
    next();
};

// Ruta para mostrar un JSON (GET) de los datos fijos globales
router.get(
    "/globales",
    authenticate, 
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/datosfijo.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        {
                            error: "Error interno del servidor"
                        }
                    );
                }
                try {
                    const jsonData = JSON.parse(data);
                    res.status(200).json(jsonData);
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        {
                            error: "Error en el formato del JSON"
                        }
                    );
                }
            }
        );
    }
);

// Ruta para mostrar un JSON (GET) de los datos fijos especificos de la clinica
router.get(
    "/clinicadentalimagen",
    authenticate, 
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/datosclinicaimagen.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        {
                            error: "Error interno del servidor"
                        }
                    );
                }
                try {
                    const jsonData = JSON.parse(data);
                    res.status(200).json(jsonData);
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        {
                            error: "Error en el formato del JSON"
                        }
                    );
                }
            }
        );
    }
);

// Ruta para mostrar un JSON (GET) de los datos fijos sobre paises
router.get(
    "/paises",
    authenticate, 
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/paises.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        {
                            error: "Error interno del servidor"
                        }
                    );
                }
                try {
                    const jsonData = JSON.parse(data);
                    res.status(200).json(jsonData.countries);
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        {
                            error: "Error en el formato del JSON"
                        }
                    );
                }
            }
        );
    }
);

// Ruta para mostrar un JSON (GET) de los datos fijos sobre departamentos del peru
router.get(
    "/departamentos",
    authenticate, 
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/departamentos.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        {
                            error: "Error interno del servidor"
                        }
                    );
                }
                try {
                    const jsonData = JSON.parse(data);
                    res.status(200).json(jsonData.departamentos);
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        {
                            error: "Error en el formato del JSON"
                        }
                    );
                }
            }
        );
    }
);

// Ruta para mostrar un JSON (GET) de los datos fijos sobre provincias del peru 
// con filtro por departamento
router.get(
    "/provincias",
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/provincias.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        { error: "Error interno del servidor" }
                    );
                }

                try {
                    let jsonData = JSON.parse(data);
                    let webhooks = jsonData.provincias;
                    const { departamento } = req.query;
                    // Filtrar por departamento
                    if (departamento) {
                        webhooks = webhooks.filter(w => w.department_id === departamento);
                    }
                    res.status(200).json({ webhooks });
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        { error: "Error en el formato del JSON" }
                    );
                }
            }
        );
    }
);

// Ruta para mostrar un JSON (GET) de los datos fijos sobre provincias del peru 
// con filtro por provincia
router.get(
    "/distritos",
    (req, res) => {
        const filePath = path.join(
            __dirname,
            "../data/distritos.json"
        );
        fs.readFile(
            filePath,
            "utf8",
            (err, data) => {
                if (err) {
                    console.error("Error al leer el archivo JSON:", err);
                    return res.status(500).json(
                        { error: "Error interno del servidor" }
                    );
                }
                try {
                    let jsonData = JSON.parse(data);
                    let webhooks = jsonData.distritos;
                    const { provincia } = req.query;
                    // Filtrar por provincia
                    if (provincia) {
                        webhooks = webhooks.filter(w => w.province_id === provincia);
                    }
                    res.status(200).json({ webhooks });
                } catch (parseError) {
                    console.error("Error al parsear el JSON:", parseError);
                    res.status(500).json(
                        { error: "Error en el formato del JSON" }
                    );
                }
            }
        );
    }
);

module.exports = router;